/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.IVWConfigStatusListener;
import filenet.vw.toolkit.admin.IVWConfigTreeNode;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigStatusEvent;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public class VWConfigRootNode
extends VWConfigBaseNode
implements IVWConfigTreeNode {
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("Config_flat_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("Config_flat_16.gif");
    protected EventListenerList m_listenerList = null;
    protected Vector m_modifiedNodes = null;
    protected String m_baseURL = null;

    public VWConfigRootNode(String baseURL) {
        super(VWResource.ConsoleRoot, 17, VWConfigActionCommand.ACMD_CONSOLE_ROOT);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.m_baseURL = baseURL;
        this.m_listenerList = new EventListenerList();
    }

    public void refresh() {
        try {
            int rootChildCount = this.getChildCount();
            for (int j = rootChildCount - 1; j >= 0; --j) {
                VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)this.getChildAt(j);
                if (serviceNode.getChildCount() <= 0) {
                    this.remove(j);
                }
                serviceNode.refresh();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setupIsolatedRegions(VWSessionInfo vwSessionInfo) {
        try {
            String[] routerNames = vwSessionInfo.getRouterNames();
            String[] routerPorts = vwSessionInfo.getRouterPorts();
            String[] routerServiceNames = vwSessionInfo.getRouterServiceNames();
            String[] routerIsolatedRegions = vwSessionInfo.getRouterIsolatedRegions();
            String hostName = vwSessionInfo.getProperty("routerHostName");
            if (hostName == null || hostName.length() == 0) {
                hostName = vwSessionInfo.getProperty("hostName");
            }
            if (routerNames == null || routerPorts == null || routerServiceNames == null || routerIsolatedRegions == null) {
                VWDebug.logError(VWResource.RouterInfomationMissing);
                JOptionPane.showMessageDialog(null, VWResource.RouterInfomationMissing, VWIDMBaseFactory.instance().getVWString(4).toString(), 0);
                return;
            }
            boolean bPaired = true;
            int sz = routerNames.length;
            int portsListLength = routerPorts.length;
            int serviceNameListLength = routerServiceNames.length;
            int regionIdListLength = routerIsolatedRegions.length;
            String errMsg = null;
            if (sz != portsListLength || portsListLength != serviceNameListLength || serviceNameListLength != regionIdListLength) {
                errMsg = VWResource.RouterInfomationMissing;
                VWDebug.logError(errMsg);
                bPaired = false;
            }
            if (!bPaired) {
                if (portsListLength < sz) {
                    errMsg = VWResource.RouterInfoInsufficient.toString(routerNames[sz - 1]);
                    VWDebug.logError(errMsg);
                    JOptionPane.showMessageDialog(null, errMsg, VWIDMBaseFactory.instance().getVWString(4).toString(), 0);
                    sz = portsListLength;
                }
                if (serviceNameListLength < sz) {
                    errMsg = VWResource.RouterInfoInsufficient.toString(routerNames[sz - 1]);
                    VWDebug.logError(errMsg);
                    JOptionPane.showMessageDialog(null, errMsg, VWIDMBaseFactory.instance().getVWString(4).toString(), 0);
                    sz = serviceNameListLength;
                }
                if (regionIdListLength < sz) {
                    errMsg = VWResource.RouterInfoInsufficient.toString(routerNames[sz - 1]);
                    VWDebug.logError(errMsg);
                    JOptionPane.showMessageDialog(null, errMsg, VWIDMBaseFactory.instance().getVWString(4).toString(), 0);
                    sz = regionIdListLength;
                }
            }
            for (int i = 0; i < sz; ++i) {
                try {
                    routerServiceNames[i] = routerServiceNames[i].trim();
                    routerIsolatedRegions[i] = routerIsolatedRegions[i].trim();
                    routerPorts[i] = routerPorts[i].trim();
                    routerServiceNames[i] = routerServiceNames[i].trim();
                    int regionId = Integer.parseInt(routerIsolatedRegions[i]);
                    int portId = Integer.parseInt(routerPorts[i]);
                    String serviceNodeName = routerServiceNames[i] + " [" + routerPorts[i] + "]";
                    VWConfigVWServiceNode serviceNode = this.findServiceNode(serviceNodeName);
                    String nodeName = routerNames[i] + " [" + routerIsolatedRegions[i] + "]";
                    VWConfigRegionNode isolatedRegion = serviceNode.findRegionNode(regionId);
                    if (isolatedRegion == null) {
                        isolatedRegion = new VWConfigRegionNode(nodeName, routerNames[i], regionId, hostName, routerServiceNames[i], portId, this.m_baseURL);
                        serviceNode.add(isolatedRegion);
                        continue;
                    }
                    errMsg = VWResource.RouterInfoDuplicated.toString(routerServiceNames[i] + ":" + routerNames[i], isolatedRegion.getServiceName() + ":" + isolatedRegion.getRouterName(), routerIsolatedRegions[i]);
                    System.out.println(errMsg);
                    continue;
                }
                catch (NumberFormatException ex) {
                    errMsg = VWResource.RouterInfoInvalid.toString(routerNames[i], routerPorts[i], routerIsolatedRegions[i]);
                    VWDebug.logError(errMsg);
                    JOptionPane.showMessageDialog(null, errMsg, VWIDMBaseFactory.instance().getVWString(4).toString(), 0);
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public Vector getAllRegions(boolean bLoggedOn) {
        Vector<VWConfigRegionNode> regions = null;
        try {
            int rootChildCount = this.getChildCount();
            for (int i = 0; i < rootChildCount; ++i) {
                VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)this.getChildAt(i);
                int serviceChildCount = serviceNode.getChildCount();
                for (int j = 0; j < serviceChildCount; ++j) {
                    VWConfigRegionNode rNode = (VWConfigRegionNode)serviceNode.getChildAt(j);
                    if (bLoggedOn && rNode.getSession() == null) continue;
                    if (regions == null) {
                        regions = new Vector<VWConfigRegionNode>();
                    }
                    regions.addElement(rNode);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return regions;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)this.getChildAt(i);
            if (!sNode.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void releaseResources() {
        this.m_baseURL = null;
        if (this.m_modifiedNodes != null) {
            this.m_modifiedNodes.removeAllElements();
            this.m_modifiedNodes = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWConfigStatusListener.class, (IVWConfigStatusListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        super.releaseResources();
    }

    public void addConfigStatusListener(IVWConfigStatusListener csl) {
        this.m_listenerList.add(IVWConfigStatusListener.class, csl);
    }

    public void removeConfigStatusListener(IVWConfigStatusListener csl) {
        this.m_listenerList.remove(IVWConfigStatusListener.class, csl);
    }

    public void fireConfigStatusEvent(VWConfigStatusEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWConfigStatusListener.class) continue;
            ((IVWConfigStatusListener)listeners[i + 1]).configStatusChanged(event);
        }
    }

    public Vector getModifiedNodeList() {
        return this.m_modifiedNodes;
    }

    public void setModifiedNodeList(Vector modifiedNodes) {
        this.m_modifiedNodes = modifiedNodes;
    }

    public void selectExportComponents() {
    }

    private VWConfigVWServiceNode findServiceNode(String serviceName) {
        VWConfigVWServiceNode serviceNode = null;
        boolean bFound = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            serviceNode = (VWConfigVWServiceNode)this.getChildAt(i);
            if (VWStringUtils.compare(serviceNode.m_name, serviceName) != 0) continue;
            bFound = true;
            break;
        }
        if (!bFound) {
            serviceNode = new VWConfigVWServiceNode(serviceName);
            this.add(serviceNode);
        }
        return serviceNode;
    }
}

